<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Maximum allowed unique IPs
$max_allowed_ips = 20;

// File to store allowed IPs
$allowed_ips_file = 'allowed_ips.txt';

// Function to load allowed IPs from the file
function load_allowed_ips($file) {
    if (file_exists($file)) {
        return file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    }
    return [];
}

// Function to save allowed IPs to the file
function save_allowed_ips($file, $ips) {
    file_put_contents($file, implode(PHP_EOL, $ips));
}

// Get the user's IP address
$user_ip = $_SERVER['REMOTE_ADDR'];

// Load current allowed IPs
$allowed_ips = load_allowed_ips($allowed_ips_file);

// Check if the user's IP is already in the allowed list
if (!in_array($user_ip, $allowed_ips)) {
    // If not, check if we can add a new IP
    if (count($allowed_ips) < $max_allowed_ips) {
        $allowed_ips[] = $user_ip; // Add the new IP
        save_allowed_ips($allowed_ips_file, $allowed_ips); // Save updated list
    } else {
        header('HTTP/1.0 403 Forbidden');
        echo "Access denied: Maximum number of allowed IPs reached.";
        exit;
    }
}

// List of proxy URLs to fetch from
$proxy_urls = [
    "https://proxoid.net/api/getProxy?key=1bd7e20b1d261c19a953d6d18347e214&countries=all&types=http,https&level=all&speed=0&count=0",
    "https://api.proxyscrape.com/v3/free-proxy-list/get?request=displayproxies&protocol=http&proxy_format=ipport&format=text&timeout=20000",
    // Add more URLs here
];

$cache_file = 'cached_pbhstoreproxy.txt';  // File to store cached proxies
$cache_time = 300;  // Cache time in seconds (5 minutes)

// Function to fetch proxies
function fetch_proxies($urls) {
    $proxies = [];

    foreach ($urls as $url) {
        $response = @file_get_contents($url);
        if ($response !== false) {
            // Check if the response is JSON
            if (is_json($response)) {
                $json_proxies = json_decode($response, true);
                $proxies = array_merge($proxies, $json_proxies);
            } else {
                $lines = explode(PHP_EOL, trim($response));
                $proxies = array_merge($proxies, $lines);
            }
        } else {
            error_log("Failed to fetch proxies from: $url");
            echo "Failed to fetch proxies from: $url<br>"; // Debug output
        }
    }

    return array_unique($proxies); // Remove duplicates
}

// Function to check if a string is valid JSON
function is_json($string) {
    json_decode($string);
    return json_last_error() === JSON_ERROR_NONE;
}

// Check if the cached proxies file exists and is still valid
if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_time) {
    // Load proxies from the cache file
    $cached_proxies = file($cache_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
} else {
    // Fetch proxies if cache is expired or does not exist
    $cached_proxies = fetch_proxies($proxy_urls);
    // Save the proxies to the cache file
    file_put_contents($cache_file, implode(PHP_EOL, $cached_proxies));
}

// Serve the cached proxies as plain text, one per line
header('Content-Type: text/plain');
if (!empty($cached_proxies)) {
    echo implode(PHP_EOL, $cached_proxies);
} else {
    echo "No proxies available.";
}
?>
