<?php
$allowed_hwids_file = 'allowed_hwids.txt'; // Path to the HWIDs file

// Function to load allowed HWIDs from the file
function load_allowed_hwids($file_path) {
    if (!file_exists($file_path)) {
        return [];
    }
    return array_filter(array_map('trim', file($file_path)));
}

// Function to add HWID
function add_hwid($file_path, $hwid) {
    file_put_contents($file_path, $hwid . PHP_EOL, FILE_APPEND);
}

// Function to remove HWID
function remove_hwid($file_path, $hwid) {
    $hwids = load_allowed_hwids($file_path);
    $hwids = array_diff($hwids, [$hwid]);
    file_put_contents($file_path, implode(PHP_EOL, $hwids) . PHP_EOL);
}

// Function to check HWID access
function check_hwid($file_path, $hwid) {
    $hwids = load_allowed_hwids($file_path);
    return in_array($hwid, $hwids) ? "allowed" : "denied";
}

// Handle POST requests
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];
        $hwid = trim($_POST['hwid']);

        if ($action === 'add' && !empty($hwid)) {
            add_hwid($allowed_hwids_file, $hwid);
            echo "HWID added: $hwid";
        } elseif ($action === 'remove' && !empty($hwid)) {
            remove_hwid($allowed_hwids_file, $hwid);
            echo "HWID removed: $hwid";
        } elseif ($action === 'check' && !empty($hwid)) {
            echo check_hwid($allowed_hwids_file, $hwid);
        } else {
            echo "Invalid action.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HWID Management</title>
</head>
<body>
    <h1>HWID Management</h1>
    <form method="POST">
        <input type="text" name="hwid" placeholder="Enter HWID" required>
        <select name="action">
            <option value="add">Add HWID</option>
            <option value="remove">Remove HWID</option>
            <option value="check">Check HWID Access</option>
        </select>
        <button type="submit">Submit</button>
    </form>
</body>
</html>
