<?php
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

// List of allowed IP addresses
$allowed_ips = [
    '122.182.218.44', // Allowed IP address 1
    '35.239.22.87',   // Allowed IP address 2 (example)
    '106.213.82.77', //The Strock Street 18Oct
    '34.16.56.171',
    '171.48.62.54',
    '34.212.134.22',
    '20.40.46.218',
    '223.177.68.102', //akhil
    // Add more allowed IPs as needed
];

$user_ip = getUserIP();
if (in_array($user_ip, $allowed_ips)) {
    // If the user's IP matches one of the allowed IPs
    header('Content-Type: application/json');
    echo json_encode(['status' => 'success', 'message' => 'Access granted', 'ip' => $user_ip]);
} else {
    // If the user's IP doesn't match any of the allowed IPs
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'Access denied', 'ip' => $user_ip]);
}
?>
