<?php
// hwid_control.php

// Set the content type to JSON
header('Content-Type: application/json');

// Predefined list of allowed HWIDs (you can use a database instead)
$allowed_hwids = [
    '00000000-0000-0000-0000-a0d768202f43',// NAWAB
    '00000000-0000-0000-0000-000c29df0d9e',// NAWAB
    '00000000-0000-0000-0000-0ae0afb400a7',  // Sahu
    '00000000-0000-0000-0000-b48c9d8c90a2', // Pratham
    '00000000-0000-0000-0000-d89ef30ed307', //Amrut
    '00000000-0000-0000-0000-200b7418de45', // Sahu 2
    '00000000-0000-0000-0000-000c29da6080'

];

// Get the HWID from the GET request
if (isset($_GET['hwid'])) {
    $hwid = $_GET['hwid'];

    // Check if the HWID is in the allowed list
    if (in_array($hwid, $allowed_hwids)) {
        // Return success response
        echo json_encode([
            'status' => 'success',
            'hwid' => $hwid
        ]);
    } else {
        // Return access denied response
        echo json_encode([
            'status' => 'denied',
            'hwid' => $hwid
        ]);
    }
} else {
    // Return an error if HWID is not provided
    echo json_encode([
        'status' => 'error',
        'message' => 'HWID not provided.'
    ]);
}
?>
