<?php
// hwid_control.php

// Set the content type to JSON
header('Content-Type: application/json');

// Predefined list of allowed HWIDs (you can use a database instead)
$allowed_hwids = [
    '00000000-0000-0000-0000-9c6b001580c9',// NAWAB
    '00000000-0000-0000-0000-a0d768202f43',// NAWAB
    '00000000-0000-0000-0000-f854f68c56e3',  // FLAME
    '00000000-0000-0000-0000-0ae0afae0404',  // FLAME
    '00000000-0000-0000-0000-cc28aa36d6da',   // SP
    '00000000-0000-0000-0000-36f1479e46bf', // ANKIT
    '00000000-0000-0000-0000-b46bfc2eb7d7', // Mahendra 
    '00000000-0000-0000-0000-b0c090c6cc1d', // pawan
    '00000000-0000-0000-0000-02baa7a9e8e9' //Sasamjack

    
];

// Get the HWID from the GET request
if (isset($_GET['hwid'])) {
    $hwid = $_GET['hwid'];

    // Check if the HWID is in the allowed list
    if (in_array($hwid, $allowed_hwids)) {
        // Return success response
        echo json_encode([
            'status' => 'success',
            'hwid' => $hwid
        ]);
    } else {
        // Return access denied response
        echo json_encode([
            'status' => 'denied',
            'hwid' => $hwid
        ]);
    }
} else {
    // Return an error if HWID is not provided
    echo json_encode([
        'status' => 'error',
        'message' => 'HWID not provided.'
    ]);
}
?>
