<?php
// hwid_control.php

// Set the content type to JSON
header('Content-Type: application/json');

// Predefined list of allowed HWIDs (you can use a database instead)
$allowed_hwids = [
    '00000000-0000-0000-0000-a0d768202f43',  // NAWAB
    '00000000-0000-0000-0000-bce92feae85b',// LUCIFER 2FEB
    '00000000-0000-0000-0000-e40d36746101',  // SURAJ 14JAN
    '00000000-0000-0000-0000-4ccc6a5422e8',   // sha
    '00000000-0000-0000-0000-d843aeb4c256', // Nawab2 pc
    '00000000-0000-0000-0000-505a65748dc5', // annu 14jan
    '00000000-0000-0000-0000-7440bbb7ae6', // lAPPY
    '00000000-0000-0000-0000-544810c3fc74', //lappy nawab
    '00000000-0000-0000-0000-f854f68c56e3', //flame
    '00000000-0000-0000-0000-9c6b001580c9', // Nawab pc
    '00000000-0000-0000-0000-18c04d660b39' // Yakesh 12 feb
];

// Get the HWID from the GET request
if (isset($_GET['hwid'])) {
    $hwid = $_GET['hwid'];

    // Check if the HWID is in the allowed list
    if (in_array($hwid, $allowed_hwids)) {
        // Return success response
        echo json_encode([
            'status' => 'success',
            'hwid' => $hwid
        ]);
    } else {
        // Return access denied response
        echo json_encode([
            'status' => 'denied',
            'hwid' => $hwid
        ]);
    }
} else {
    // Return an error if HWID is not provided
    echo json_encode([
        'status' => 'error',
        'message' => 'HWID not provided.'
    ]);
}
?>
