<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// List of proxy URLs to fetch from
$proxy_urls = [
    "https://proxoid.net/api/getProxy?key=1bd7e20b1d261c19a953d6d18347e214&countries=all&types=http,https&level=all&speed=0&count=0",
    "https://api.proxyscrape.com/v3/free-proxy-list/get?request=displayproxies&protocol=http&proxy_format=ipport&format=text&timeout=20000",
    "https://raw.githubusercontent.com/TheSpeedX/SOCKS-List/master/http.txt"
];

// Function to fetch proxies from URLs
function fetch_proxies($urls) {
    $proxies = [];
    foreach ($urls as $url) {
        $response = @file_get_contents($url);
        if ($response !== false) {
            $lines = explode(PHP_EOL, trim($response));
            $proxies = array_merge($proxies, $lines);
        }
    }
    return array_unique($proxies); // Remove duplicates
}

// Fast validation: Check if proxy is responding within a short time frame
function is_active_proxy($proxy) {
    $url = 'https://httpbin.org/ip';  // Simple URL to test proxies
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_PROXY, $proxy);
    curl_setopt($ch, CURLOPT_TIMEOUT, 3); // Fast timeout after 3 seconds
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return $http_code == 200;  // Return true if proxy returns status 200
}

// Fetch proxies from sources
$raw_proxies = fetch_proxies($proxy_urls);

// Validate and filter only active proxies
$active_proxies = [];

foreach ($raw_proxies as $proxy) {
    if (is_active_proxy(trim($proxy))) {
        $active_proxies[] = $proxy; // Only add active proxies
    }
}

// Output active proxies instantly as plain text
header('Content-Type: text/plain');
if (!empty($active_proxies)) {
    echo implode(PHP_EOL, $active_proxies);
} else {
    echo "No active proxies available.";
}
?>
