<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Set execution time limit
set_time_limit(0);

// List of proxy URLs to fetch from
$proxy_urls = [
    "https://proxoid.net/api/getProxy?key=1bd7e20b1d261c19a953d6d18347e214&countries=all&types=http,https&level=all&speed=0&count=0",
    "https://api.proxyscrape.com/v3/free-proxy-list/get?request=displayproxies&protocol=http&proxy_format=ipport&format=text&timeout=20000",
];

// Cache file for storing active proxies
$cache_file = '/home/pbhstor1/domains/chatbot.pbhstore.in/public_html/Verify/active_proxies_cache.txt';

// Function to fetch proxies from URLs
function fetch_proxies($urls) {
    $proxies = [];
    foreach ($urls as $url) {
        $response = @file_get_contents($url);
        if ($response !== false) {
            $lines = explode(PHP_EOL, trim($response));
            $proxies = array_merge($proxies, $lines);
        } else {
            error_log("Failed to fetch proxies from: $url");
        }
    }
    return array_unique($proxies);
}

// Function to validate proxies using cURL
function validate_proxy($proxy) {
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, 'https://httpbin.org/ip'); // Change URL to test with
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_PROXY, $proxy);
    curl_setopt($curl, CURLOPT_TIMEOUT, 5); // Timeout after 5 seconds

    curl_exec($curl); // Execute the request
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE); // Get the response code
    curl_close($curl); // Close the cURL handle

    return $http_code == 200; // Return true if the response code is 200
}

// Function to continuously verify proxies in the background
function run_proxy_verification($proxy_urls, $cache_file) {
    $raw_proxies = fetch_proxies($proxy_urls);
    $active_proxies = [];

    foreach ($raw_proxies as $proxy) {
        if (validate_proxy($proxy)) {
            $active_proxies[] = $proxy;
            echo "Valid Proxy: $proxy\n"; // Output valid proxy
        } else {
            echo "Invalid Proxy: $proxy\n"; // Output invalid proxy
        }
    }

    // Save active proxies to the cache file
    file_put_contents($cache_file, implode(PHP_EOL, $active_proxies));
}

// Start the verification process
run_proxy_verification($proxy_urls, $cache_file);
?>
