<?php

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Function to get the live status of a YouTube channel
function getYouTubeLiveStatus($apiKey, $channelId) {
    $url = "https://www.googleapis.com/youtube/v3/search?key={$apiKey}&channelId={$channelId}&eventType=live&type=video";
    $response = @file_get_contents($url);

    // Check for errors in fetching the response
    if ($response === FALSE) {
        file_put_contents('error.log', "API call failed: " . json_encode($http_response_header) . "\n", FILE_APPEND);
        return 'error'; // Return error status
    }

    $data = json_decode($response, true);

    // Check if there are live broadcasts
    if (isset($data['items']) && count($data['items']) > 0) {
        return 'live'; // Stream is live
    }

    // Return 'no_data' if no items found
    return 'no_data'; // No live broadcast found
}

// Function to send email notifications
function sendEmailNotification($message) {
    $to = 'royalnawab0538@gmail.com'; // Your email address
    $subject = 'YouTube Live Stream Notification';
    $headers = 'From: royalnawab0538@gmail.com' . "\r\n" . // Your sending email address
               'Reply-To: royalnawab0538@gmail.com' . "\r\n" . // Your replying email address
               'X-Mailer: PHP/' . phpversion();

    mail($to, $subject, $message, $headers);
}

// Function to send a test email
function sendTestEmail() {
    $to = 'royalnawab0538@gmail.com'; // Your email address
    $subject = 'Test Email from YouTube Notification Script';
    $message = 'This is a test email to verify that the email notification system is working properly.';
    $headers = 'From: royalnawab0538@gmail.com' . "\r\n" . // Your sending email address
               'Reply-To: royalnawab0538@gmail.com' . "\r\n" . // Your replying email address
               'X-Mailer: PHP/' . phpversion();

    mail($to, $subject, $message, $headers);
}

// YouTube API Key and Channel ID
$apiKey = 'AIzaSyBbeQuXYwWOgsNaxcWt_sOWRSGzx01mPYo'; // Replace with your YouTube API key
$channelId = 'UCg35PzQUR1_eyHR3llQ_DrQ'; // Replace with your YouTube channel ID

// Check the live stream status
$streamStatus = getYouTubeLiveStatus($apiKey, $channelId);

// Send a notification based on the stream status
if ($streamStatus === 'none') {
    sendEmailNotification("Your scheduled stream has paused or ended.");
} elseif ($streamStatus === 'no_data') {
    sendEmailNotification("No data received from the live stream.");
} elseif ($streamStatus === 'error') {
    // Handle API call errors
    sendEmailNotification("There was an error fetching the live stream status.");
} else {
    echo "The stream is currently live.";
}

// Call the test email function
sendTestEmail();

?>
